#include "task.h"
#include <saas/deploy_manager/scripts/searchmap/action.h>
#include <saas/deploy_manager/scripts/deploy/action.h>
#include <saas/library/searchmap/searchmap.h>
#include <saas/rtyserver/controller/controller_actions/clear_index_action.h>

namespace NRTYDeploy {

    TActivateSlotsTask::TActivateSlotsTask(const NSearchMapParser::TSlotsPool& slots, const TClusterTask::TCgiContext& context, NRTYDeploy::ICommonData* commonData)
        : TClusterTask(context, commonData, ACTIVATE_SLOTS_TASK_TYPE)
    {
        CHECK_WITH_LOG(!slots.GetSlots().empty());
        Slots = slots;
    }

    void TActivateSlotsTask::DoBuildTask() {
        const TVector<NSearchMapParser::TSearchMapHost>& slots = Slots.GetSlots();
        TVector<TString> starts;
        for (TVector<NSearchMapParser::TSearchMapHost>::const_iterator i = slots.begin(); i != slots.end(); ++i)
            starts.push_back(GetScript()->AddAction(i->Name, i->ControllerPort(), "", new NDaemonController::TClearIndexAction(NDaemonController::apStart)).GetName());
        for (TVector<NSearchMapParser::TSearchMapHost>::const_iterator i = slots.begin(); i != slots.end(); ++i)
            GetScript()->AddAction(i->Name, i->ControllerPort(), "", new NDaemonController::TClearIndexAction(starts[i - slots.begin()]));

        NDaemonController::TAction::TPtr actionDeploy = new NRTYDeploy::TDeployAction(Service, CType, "CURRENT", NDaemonController::apStartAndWait, ServiceType, 1, &Slots);
        GetScript()->AddAction(CommonData->GetDeployManagerBalanserHost(), CommonData->GetDeployManagerBalanserPort(), CommonData->GetDeployManagerBalanserUriPrefix(), actionDeploy);
    }

};
