#include "action.h"

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NRTYDeploy {

    NJson::TJsonValue TAggregateAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        NJson::TJsonValue poolsJson(NJson::JSON_ARRAY);
        NJson::TJsonValue resultPoolJson(ResultPool.Serialize());

        for (auto&& i : Pools) {
            poolsJson.AppendValue(i);
        }

        result.InsertValue("pools", std::move(poolsJson));
        result.InsertValue("result_pool", std::move(resultPoolJson));
        return result;
    }

    void TAggregateAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        const NJson::TJsonValue& poolsJson = json["pools"];
        const NJson::TJsonValue& resultPoolJson = json["result_pool"];

        CHECK_WITH_LOG(poolsJson.IsArray());
        const NJson::TJsonValue::TArray& arr = poolsJson.GetArray();
        Pools.reserve(arr.size());
        for (const auto& i : arr) {
            Pools.push_back(i.GetStringRobust());
        }
        CHECK_WITH_LOG(ResultPool.DeserializeFromJson(resultPoolJson));
    }

    TAggregateAction::TFactory::TRegistrator<TAggregateAction> TAggregateAction::Registrator(AGGREGATE_ACTION_NAME);
}
