#pragma once
#include <saas/deploy_manager/scripts/allocate_slots/common/intervals.h>
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/deploy_manager/scripts/common/slots_allocator/allocator.h>
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <saas/library/searchmap/slots_pool.h>
#include <util/string/vector.h>

#define ALLOCATE_SLOTS_REPLICAS_ACTION_NAME "ALLOCATE_SLOTS_REPLICAS"

namespace NDaemonController {

    class TAllocateSlotsReplicasAction: public TAction {
    private:
        TIntervalsByDC Intervals;
        NRTYCluster::TSlotsAllocator Allocator;
        ui32 ReplicasCount;
        TString CType;
        TString Service;
        TString ServiceType;
        NSearchMapParser::TSlotsPool ResultPool;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUri() const override {
            return "allocate_slots_replicas";
        }

        virtual TString DoBuildCommand() const override {
            return "intervals=" + Intervals.SerializeToJson().GetStringRobust() +
                "&allocator=" + Allocator.SerializeToJson().GetStringRobust() +
                "&service_type=" + ServiceType +
                "&ctype=" + CType +
                "&replicas_count=" + ToString(ReplicasCount) +
                "&service=" + Service;
        }

        virtual void DoInterpretResult(const TString& result) override;

        static TFactory::TRegistrator<TAllocateSlotsReplicasAction> Registrator;
    public:

        TAllocateSlotsReplicasAction() {}

        TAllocateSlotsReplicasAction(const TIntervalsByDC& intervals, ui32 replicasCount, const NRTYCluster::TSlotsAllocator& allocator, const TString& service, const TString& ctype, const TString& serviceType)
            : Intervals(intervals),
              Allocator(allocator),
              ReplicasCount(replicasCount),
              CType(ctype),
              Service(service),
              ServiceType(serviceType)
        {}

        virtual ui32 GetAttemptionsMaxResend() const override {
            return 1;
        }

        virtual TDuration GetTimeoutDuration() const override {
            return TDuration::Seconds(100);
        }

        virtual TString ActionName() const override { return ALLOCATE_SLOTS_REPLICAS_ACTION_NAME; }
    };
}
