#include "action_same.h"

#include <saas/deploy_manager/meta/cluster.h>
#include <saas/library/searchmap/parsers/json/json.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/logger/global/global.h>
#include <util/stream/str.h>

namespace NDaemonController {
    NJson::TJsonValue TAllocateSameSlotsAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("intervals", Intervals.SerializeToJson());
        result.InsertValue("ctype", CType);
        result.InsertValue("service", Service);
        result.InsertValue("service_type", ServiceType);
        result.InsertValue("new_slots_pool", JoinStrings(NewSlotsPool, ","));
        if (ResultPool.Size())
            result.InsertValue("result_pool", ResultPool.Serialize());
        return result;
    }

    void TAllocateSameSlotsAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        CHECK_WITH_LOG(json.IsMap());
        if (!Intervals.DeserializeFromJson(json["intervals"]))
            Fail("Incorrect intervals data " + json["slots"].GetStringRobust());
        CType = json["ctype"].GetStringRobust();
        Service = json["service"].GetStringRobust();
        ServiceType = json["service_type"].GetStringRobust();
        NewSlotsPool = SplitString(json["new_slots_pool"].GetStringRobust(), ",");
        if (json.Has("result_pool"))
            ResultPool.DeserializeFromJson(json["result_pool"]);
    }

    void TAllocateSameSlotsAction::DoInterpretResult(const TString& result) {
        if (!ResultPool.DeserializeFromString(result))
            Fail("incorrect slots pool: " + result);
        else
            Success("OK");
    }

    TAllocateSameSlotsAction::TFactory::TRegistrator<TAllocateSameSlotsAction> TAllocateSameSlotsAction::Registrator(ALLOCATE_SAME_SLOTS_ACTION_NAME);
}
