#pragma once
#include <saas/deploy_manager/scripts/allocate_slots/common/intervals.h>
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <saas/library/searchmap/slots_pool.h>
#include <util/string/vector.h>

#define ALLOCATE_SAME_SLOTS_ACTION_NAME "ALLOCATE_SAME_SLOTS"

namespace NDaemonController {

    class TAllocateSameSlotsAction: public TAction {
    private:
        TString CType;
        TString Service;
        TString ServiceType;
        TIntervalsByDC Intervals;
        TVector<TString> NewSlotsPool;
        NSearchMapParser::TSlotsPool ResultPool;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString GetCustomUri() const override {
            return "allocate_same_slots";
        }

        virtual TString DoBuildCommand() const override {
            return "intervals=" + Intervals.SerializeToJson().GetStringRobust() +
                "&service_type=" + ServiceType +
                "&ctype=" + CType +
                "&service=" + Service +
                "&new_slots_pool=" + JoinStrings(NewSlotsPool, ",");
                ;
        }

        virtual void DoInterpretResult(const TString& result) override;

        static TFactory::TRegistrator<TAllocateSameSlotsAction> Registrator;
    public:

        TAllocateSameSlotsAction() {}

        TAllocateSameSlotsAction(const TString& ctype, const TString& service, const TString& serviceType, const TIntervalsByDC& intervals, const TVector<TString>& newSlotsPool)
            : CType(ctype)
            , Service(service)
            , ServiceType(serviceType)
            , Intervals(intervals)
            , NewSlotsPool(newSlotsPool)
        {}

        virtual ui32 GetAttemptionsMaxResend() const override {
            return 1;
        }

        virtual TDuration GetTimeoutDuration() const override {
            return TDuration::Seconds(100);
        }

        virtual TString ActionName() const override { return ALLOCATE_SAME_SLOTS_ACTION_NAME; }
    };
}
