#pragma once

#include <saas/library/daemon_base/actions_engine/controller_client.h>

#define BROADCAST_ACTION_NAME "BROADCAST"

namespace NDaemonController {

    class TBroadcastAction : public TAction {
    private:
        TString Command;
        TString CType;
        TString Service;
        TString ServiceType;
        bool IgnoreUnknowPath = false;
        TSet<TString> Filter;
        NJson::TJsonValue Result;
        TString SearchMap;
        TDuration Timeout;
        bool IsMultipleMap = false;
        bool WithSd = true;

    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;
        virtual TString DoBuildCommand() const override;
        virtual void DoInterpretResult(const TString& result) override;
        virtual TString GetCustomUri() const override {
            return "broadcast";
        }
        virtual bool GetPostContent(TString& result) const override {
            if (!!SearchMap)
                result = SearchMap;
            return !!SearchMap;
        }

        static TFactory::TRegistrator<TBroadcastAction> Registrator;
    public:

        TBroadcastAction() {}

        TBroadcastAction(const TString& command, const TString& ctype, const TString& service, const TString& serviceType, bool ignoreUnknowPath = false, const TString& searchMap = TString(), TDuration timeout = TDuration::Seconds(1));

        virtual TString ActionName() const override {
            return BROADCAST_ACTION_NAME;
        }

        TSet<TString>& GetFilter() {
            return Filter;
        }

        const NJson::TJsonValue& GetResult() const {
            return Result;
        }

        virtual TDuration GetTimeoutDuration() const override {
            return Timeout;
        }

        void SetIsMultiple(bool isMultipleMap) {
            IsMultipleMap = isMultipleMap;
        }

        void SetWithSd(bool withSd) {
            WithSd = withSd;
        }
    };
}
