#pragma once
#include <saas/library/searchmap/host.h>

namespace NRTYDeploy {

    struct TBroadcastSlotData {
        NSearchMapParser::TSearchMapHost SMHost;
        TString ServiceName;
        TString ConfigType;

        TBroadcastSlotData() {

        }

        TBroadcastSlotData(const NSearchMapParser::TSearchMapHost& smhost, const TString& serviceName, const TString& confType)
            : SMHost(smhost)
            , ServiceName(serviceName)
            , ConfigType(confType)
        {}

        bool operator < (const TBroadcastSlotData& value) const {
            if (ServiceName == value.ServiceName) {
                if (ConfigType == value.ConfigType)
                    return SMHost.GetSlotName() < value.SMHost.GetSlotName();
                else
                    return ConfigType < value.ConfigType;
            } else
                return ServiceName < value.ServiceName;
        }

    };

}
