#pragma once

#include "broadcast_slot_data.h"

#include <search/meta/scatter/async/runner.h>
#include <search/meta/scatter/helpers.h>
#include <search/meta/scatter/options/options.h>
#include <search/meta/scatter/result.h>
#include <search/meta/scatter/request.h>
#include <search/meta/scatter/source.h>
#include <search/meta/scatter/task.h>
#include <search/meta/scatter/wait_policy.h>

#include <saas/util/queue.h>

namespace NRTYDeploy {

    class TScriptBroadcast;

    class TBroadcastSender {
    private:
        TMap<TBroadcastSlotData, TAutoPtr<NScatter::ISource>> Sources;
        TMap<TString, TBroadcastSlotData> SlotsData;
        TMap<TString, TString> Errors;
        NScatter::TSourceOptions Opts;
        TScriptBroadcast& Script;
        NScatter::TAsyncTaskRunner Requester;

    public:
        TBroadcastSender(TScriptBroadcast& script)
            : Script(script)
        {
            Opts.ConnectTimeouts.push_back(TDuration::MilliSeconds(100));
            Opts.SendingTimeouts.push_back(TDuration::MilliSeconds(500));
            Opts.EnableIpV6 = true;
            Opts.MaxAttempts = 2;
            Opts.TimeOut = TDuration::MilliSeconds(1000);
        }

        TScriptBroadcast& GetScript() {
            return Script;
        }

        void AddReply(const TString& searchScript, const TString& reply);

        void AddSource(const TBroadcastSlotData& slotData);

        void Wait();
    };
}
