#pragma once

#include <util/stream/output.h>

#include <util/generic/string.h>


namespace NRTYDeploy {

    inline bool HasNonEmptyFilter(const TString& cgi) {
        static const TString filterStr = "filter=";
        static const size_t filterLen = filterStr.size();
        size_t idx = cgi.find(filterStr);
        while (idx != TString::npos) {
            const size_t nextOffset = idx + filterLen;
            if (idx == 0 || cgi[idx - 1] == '&' || cgi[idx - 1] == '?') {
                if (nextOffset < cgi.size() && cgi[nextOffset] != '&') {
                    return true;
                }
            }
            idx = cgi.find(filterStr, nextOffset);
        }
        return false;
    }
} // namespace NRTYDeploy
