#include "url_params.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NRTYDeploy;

Y_UNIT_TEST_SUITE(TUrlTest) {

    Y_UNIT_TEST(TTestUrlMatch) {
        UNIT_ASSERT(!HasNonEmptyFilter("/broadcast"));
        UNIT_ASSERT(!HasNonEmptyFilter("/broadcast?a=b"));
        UNIT_ASSERT(HasNonEmptyFilter("/broadcast?filter=z"));
        UNIT_ASSERT(!HasNonEmptyFilter("/broadcast?filter="));
        UNIT_ASSERT(HasNonEmptyFilter("/broadcast?filter=&d=b&filter=z"));
        UNIT_ASSERT(!HasNonEmptyFilter("/broadcast?filter=&d=b&filter="));
        UNIT_ASSERT(HasNonEmptyFilter("/broadcast?filter=1&d=b&filter="));
        UNIT_ASSERT(HasNonEmptyFilter("/broadcast?filter=&filter=a"));
        UNIT_ASSERT(!HasNonEmptyFilter("/broadcast?fakefilter=a"));
        UNIT_ASSERT(!HasNonEmptyFilter("/broadcast?filter=&fakefilter=a"));
    };

}
