#include "action.h"

namespace NDaemonController {
    NJson::TJsonValue TCheckConfigsAction::DoSerializeToJson() const {
        NJson::TJsonValue result = TBroadcastAction::DoSerializeToJson();
        result.InsertValue("interest", Interest);
        return result;
    }

    void TCheckConfigsAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        TBroadcastAction::DoDeserializeFromJson(json);
        Interest = json["interest"].GetStringRobust();
    }

    TString TCheckConfigsAction::DoBuildCommand() const {
        return TBroadcastAction::DoBuildCommand()
            + "&interest=" + Interest;
    }

    TCheckConfigsAction::TFactory::TRegistrator<TCheckConfigsAction> TCheckConfigsAction::Registrator(CHECK_CONFIGS_ACTION_NAME);
}
