#pragma once

#include <saas/deploy_manager/scripts/broadcast/broadcast_action.h>

#define CHECK_CONFIGS_ACTION_NAME "CHECK_CONFIGS"

namespace NDaemonController {

    class TCheckConfigsAction : public TBroadcastAction {
    private:
        TString Interest;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json);
        virtual TString DoBuildCommand() const;
        virtual TString GetCustomUri() const {
            return "check_configs";
        }
        virtual TDuration GetTimeoutDuration() const {
            return TDuration::Seconds(10);
        }
        static TFactory::TRegistrator<TCheckConfigsAction> Registrator;
    public:

        TCheckConfigsAction() {}

        TCheckConfigsAction(const TString& ctype, const TString& service, const TString& serviceType, bool ignoreUnknowPath = false, const TString& interest = TString(), const TString& searchmap = TString())
            : TBroadcastAction("", ctype, service, serviceType, ignoreUnknowPath, searchmap)
            , Interest(interest)
        {}

        virtual TString ActionName() const { return CHECK_CONFIGS_ACTION_NAME; }
    };
}
