#pragma once
#include <saas/deploy_manager/scripts/broadcast/broadcast.h>

namespace NRTYDeploy {
    class TScriptCheckConfigs : public TScriptBroadcast {
    public:
        static TFactory::TRegistrator<TScriptCheckConfigs> Registrator;

        TScriptCheckConfigs();

        virtual bool Process(IDeployInfoRequest& request) override;
        virtual bool MakeReport(IOutputStream& os) override;
        virtual TString Help() override { return "ctype - necessary parameter, service - optional (may be indexerproxy or searchproxy)"; }
        virtual void OnHost(const NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& replica, const NSearchMapParser::TSearchMapService& service) override;

        void ProcessAllConfigs(TFileContentGenerator::TContext &context);

        using TScriptBroadcast::OnHost;

        enum THashName
        {
            hnNEW,
            hnCURRENT,
            hnTAKED,
            hnNEW_FULL = hnNEW + 10000,
            hnCURRENT_FULL = hnCURRENT + 10000
        };

    private:
        struct TFileHashes {
            void Set(THashName name, const TString& value) {
                Hash[name] = value;
            }

            const TString& Get(THashName name) const {
                THashMap<THashName, TString>::const_iterator i = Hash.find(name);
                return i == Hash.end() ? Default<TString>() : i->second;
            }

        private:
            THashMap<THashName, TString> Hash;
        };

        typedef THashMap<TString, TFileHashes> THashesByFile;
        typedef THashMap<TString, THashesByFile> THashesBySlot;
        struct TServiceDescritption {
            THashMap<THashName, TNodesStructure> Configs;
            THashesBySlot Hashes;
            typedef TSimpleSharedPtr<TServiceDescritption> TPtr;
        };

        typedef THashMap<TString, TServiceDescritption::TPtr> TServices;

    private:
        void ProcessConfigs(TServiceDescritption& service, const TFileContentGenerator::TContext& context, const TString& slot, THashName hashName);
        TServices Services;
        TSet<THashName> InterestHashes;
        ui32 FullDataLimit = 0;
    };
}
