#include "action.h"

#include <library/cpp/json/json_reader.h>

namespace NDaemonController {

    NJson::TJsonValue TCheckSlotAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("slot_name", SlotName);
        return result;
    }

    void TCheckSlotAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        SlotName = json["slot_name"].GetStringRobust();
    }

    void TCheckSlotAction::DoInterpretResult(const TString& result) {
        Success(result);
    }

    TCheckSlotAction::TFactory::TRegistrator<TCheckSlotAction> TCheckSlotAction::Registrator(CHECK_SLOT_ACTION_NAME);
}
