#pragma once
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/generic/vector.h>

#define CHECK_SLOT_ACTION_NAME "CHECK_SLOT"

namespace NDaemonController {

    class TCheckSlotAction: public TAction {
    public:

        TCheckSlotAction()
        {}

        TCheckSlotAction(const TString& slotName)
            : SlotName(slotName)
        {}

        virtual TString GetCustomUri() const override {
            return "check_slot";
        }

        virtual TString DoBuildCommand() const override {
            return "slot=" + SlotName;
        }
        virtual void DoInterpretResult(const TString& result) override;
        TString ActionName() const override { return CHECK_SLOT_ACTION_NAME; }

    protected:
        NJson::TJsonValue DoSerializeToJson() const override;
        void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TCheckSlotAction> Registrator;

    private:
        TString SlotName;
    };
}
