#include "script.h"
#include <saas/deploy_manager/server/client/client.h>

namespace NRTYDeploy {

    bool TScriptCheckSlot::Process(IDeployInfoRequest& request) {
        const TCgiParameters& cgi = request.GetRD().CgiParam;
        const TString& slotName = cgi.Get("slot");
        NRTYCluster::TSlotData sd;
        if (!NRTYCluster::TSlotData::Parse(slotName, sd)) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "incorrect slot name: " << slotName << Endl;
        } else {
            TString result = request.GetCommonData().GetControllersChecker().CheckSlot(sd).ControllerStatus.SerializeToJson().GetStringRobust();
            request.Output() << "HTTP/1.1 200 \r\n\r\n";
            request.Output() << result;
        }
        return true;
    }

    IScript::TFactory::TRegistrator<TScriptCheckSlot> TScriptCheckSlot::Registrator("check_slot");
}
