#include "action.h"

#include <library/cpp/json/json_reader.h>

namespace NDaemonController {

    NJson::TJsonValue TCheckSlotsAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        result.InsertValue("slots_vector", SlotsVector);
        result.InsertValue("service_type", ServiceType);
        result.InsertValue("ctype", CType);
        return result;
    }

    void TCheckSlotsAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        if (json.Has("slots_vector"))
            SlotsVector = json["slots_vector"].GetStringRobust();
        ServiceType = json["service_type"].GetStringRobust();
        CType = json["ctype"].GetStringRobust();
    }

    TCheckSlotsAction::TFactory::TRegistrator<TCheckSlotsAction> TCheckSlotsAction::Registrator(CHECK_SLOTS_ACTION_NAME);
}
