#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/generic/vector.h>

#define CHECK_SLOTS_ACTION_NAME "CHECK_SLOTS"

namespace NDaemonController {

    class TCheckSlotsAction: public NRTYDeploy::TClusterAsyncAction {
    public:

        TCheckSlotsAction()
        {}

        TCheckSlotsAction(const TString& slotsVector, const TString& serviceType, const TString& ctype)
            : NRTYDeploy::TClusterAsyncAction(apStartAndWait)
            , SlotsVector(slotsVector)
            , ServiceType(serviceType)
            , CType(ctype)
        {}

        void DoInterpretResult(const TString& result) override {
            NRTYDeploy::TClusterAsyncAction::DoInterpretResult(result);
        }

        virtual TString GetCustomUriStart() const override {
            return "check_slots";
        }

        virtual TString DoBuildCommandStart() const override {
            return "slots_vector=" + SlotsVector
                  + "&service_type=" + ServiceType
                  + "&ctype=" + CType;
        }

        virtual TString ActionName() const override {
            return CHECK_SLOTS_ACTION_NAME;
        }

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override ;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override ;

        static TFactory::TRegistrator<TCheckSlotsAction> Registrator;

    private:
        TString SlotsVector;
        TString ServiceType;
        TString CType;
    };
}
