#include "script.h"
#include <saas/deploy_manager/server/client/client.h>
#include <saas/deploy_manager/scripts/check_slots/task/task.h>
#include <util/string/type.h>

namespace NRTYDeploy {

    TClusterTask::TPtr TScriptCheckSlots::DoBuildTask(IDeployInfoRequest& request) const {
        const TCgiParameters& cgi = request.GetRD().CgiParam;
        TClusterTask::TCgiContext context = TClusterTask::TCgiContext::Parse(cgi);
        TString slotsVector = cgi.Get("slots_vector");
        if (!context.CType) {
            request.Output() << "HTTP/1.1 400 \r\n\r\n";
            request.Output() << "ctype does not set";
            return nullptr;
        }
        return new TCheckSlotsTask(context, &request, slotsVector);
    }

    IScript::TFactory::TRegistrator<TScriptCheckSlots> TScriptCheckSlots::Registrator("check_slots");
}
