#pragma once

#include <saas/deploy_manager/storage/abstract.h>
#include <saas/util/tasks_graph/script.h>

namespace NRTYDeploy {
    class TScriptController : public NRTYScript::IController {
    public:
        TScriptController(IVersionedStorage& storage, const TString& id);

        virtual void Start() override;
        virtual void Finish() override;
        virtual bool IsExecutable() override;
        bool SetTaskSuspended(bool suspended);

    private:
        void SetTaskStateUnsafe(NJson::TJsonValue& json);
        NJson::TJsonValue GetTaskState(bool lock = true);
        TString GetPath();

    private:
        IVersionedStorage& Storage;
        TString Id;
    };
}
