#pragma once
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/generic/vector.h>

#define CLUSTER_CONTROL_ACTION_NAME "CLUSTER_CONTROL"

namespace NDaemonController {

    class TClusterControlAction: public NRTYDeploy::TClusterAsyncAction {
    public:

        TClusterControlAction()
        {}

        TClusterControlAction(const TString& ctype, const TString& service, NDaemonController::TAsyncPolicy policy)
            : TClusterAsyncAction(policy)
            , Service(service)
            , CType(ctype)
        {
        }

        TClusterControlAction(const TString& ctype, const TString& service, const TVector<TString>& restoreSlots, const TVector<TString>& replaceSlots,
            NDaemonController::TAsyncPolicy policy, bool deployProxies)
            : TClusterAsyncAction(policy)
            , Service(service)
            , CType(ctype)
            , RestoreSlots(restoreSlots)
            , ReplaceSlots(replaceSlots)
            , DeployProxies(deployProxies)
        {
        }

        TClusterControlAction& SetNewSlotsPool(const TVector<TString>& pool) {
            NewSlotsPool = pool;
            return *this;
        }

        TClusterControlAction& SetCopySlotsPool(const TVector<TString>& pool) {
            CopySlotsPool = pool;
            return *this;
        }

        TClusterControlAction& SetAbsentSlots(const TVector<TString>& pool) {
            AbsentSlots = pool;
            return *this;
        }

        virtual TString GetCustomUriStart() const override {
            return "cluster_control";
        }

        virtual TString DoBuildCommandStart() const override {
            return "&service=" + Service + "&ctype=" + CType +
                   "&restore_slots=" + JoinStrings(RestoreSlots, ",") +
                   "&new_slots_pool=" + JoinStrings(NewSlotsPool, ",") +
                   "&replace_slots=" + JoinStrings(ReplaceSlots, ",") +
                   "&absent_replace_slots=" + JoinStrings(AbsentSlots, ",") +
                   "&copy_slots=" + JoinStrings(CopySlotsPool, ",") +
                   "&deploy_proxies=" + ToString(DeployProxies)
                   ;
        }

        virtual TString ActionName() const override { return CLUSTER_CONTROL_ACTION_NAME; }

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TClusterControlAction> Registrator;

    private:
        TString Service;
        TString CType;
        TVector<TString> RestoreSlots;
        TVector<TString> ReplaceSlots;
        TVector<TString> AbsentSlots;
        TVector<TString> NewSlotsPool;
        TVector<TString> CopySlotsPool;
        bool DeployProxies = true;
    };
}
