#pragma once
#include <saas/deploy_manager/scripts/allocate_slots/common/intervals.h>
#include <saas/deploy_manager/scripts/common/script.h>
#include <saas/deploy_manager/scripts/cluster/cluster_task.h>
#include <saas/library/searchmap/searchmap.h>
#include <saas/util/cluster/cluster.h>

#define CLUSTER_CONTROL_TASK_TYPE "CLUSTER_CONTROL_TASK"

namespace NRTYDeploy {
    class TClusterControlTask: public TClusterTask, public NSearchMapParser::ISearchMapScannerCallback {
    private:
        NRTYCluster::TCTypeCluster CTypeCluster;
        TVector<TString> PredefinedSlotsPoolRestore;
        TVector<TString> PredefinedSlotsPoolReplace;
        TVector<TString> PredefinedSlotsPoolReplaceAbsent;
        TVector<TString> NewSlotsPool;
        TVector<TString> PredefinedSlotsPoolCopy;
        TSet<TString> SlotsNotUsefulForRestoreSource;
        TMap<TString, TVector<TString>> SlotsForRelease;
        TMap<TString, NDaemonController::TIntervalsByDC> SlotsForReplace;
        TMap<TString, NSearchMapParser::TSlotsPool> SlotsForRestore;
        bool DeployProxies = true;
        float MayBeDeadIntervalPercentage = 0.5f;
    public:

        TClusterControlTask(const TClusterTask::TCgiContext& context, NRTYDeploy::ICommonData* commonData,
            const TVector<TString>& predefinedSlotsPoolRestore, const TVector<TString>& predefinedSlotsPoolReplace, const TVector<TString>& copySlotsPool,
            const TVector<TString>& newSlotsPool,  const TVector<TString>& predefinedSlotsPoolReplaceAbsent, bool deployProxies, const float mayBeDeadIntervalPercentage);

        virtual void DoBuildTask() override;

        virtual bool OnService(const NSearchMapParser::TSearchMapService& info) override;
        virtual void OnHost(const NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& replica, const NSearchMapParser::TSearchMapService& service) override;
    };

}
