#include "remove.h"

namespace NRTYAlerts {
TMap<TString, TString> JugglerFilter(const TString& service, const TString& ctype, const TString& akey) {
    TMap<TString, TString> filter;
    if (!!service) {
        filter["service"] = service;
    }
    if (!!ctype) {
        filter["ctype"] = ctype;
    }
    if (!!akey) {
        filter["skey"] = akey;
    };
    return filter;
}

bool RemoveChecksList(const NRTYDeploy::ICommonData& common, const NJson::TJsonValue& checks, NJson::TJsonValue& result) {
    result["fails"] = NJson::TJsonValue(NJson::JSON_ARRAY);
    ui16 failCnt = 0, removedCnt = 0;
    for (const auto& c : checks.GetArray()) {
        NJson::TJsonValue singleRes;
        TString tag = c.Has("tag") ? c["tag"].GetString() : "";
        TString gHost = c.Has("golem_host") ? c["golem_host"].GetString() : "";
        bool rmSuccess = common.GetJugglerModule().RemoveCheck(c["juggler_id"].GetString(), tag, gHost, singleRes);
        if (rmSuccess) {
            removedCnt++;
        } else {
            failCnt++;
            result["fails"].AppendValue(singleRes);
        }
    }
    result["cnt_removed"] = removedCnt;
    return !failCnt;
}

bool RemoveAlertsList(const NRTYDeploy::ICommonData& common, const NJson::TJsonValue& alerts, NJson::TJsonValue& result) {
    ui16 failCnt = 0, removedCnt = 0;
    for (const auto& c : alerts.GetArray()) {
        NJson::TJsonValue singleRes;
        bool rmSuccess = common.GetGolovanModule().RemoveAlert(c.GetString(), singleRes);
        if (rmSuccess) {
            removedCnt++;
        } else {
            failCnt++;
            result["fails"].AppendValue(singleRes);
        }
    }
    result["cnt_removed"] = removedCnt;
    return !failCnt;
}

bool RemoveChecksByFilter(const NRTYDeploy::ICommonData& common, const TMap<TString, TString>& filter, NJson::TJsonValue& result) {
    if (!common.GetConfig().GetAlertsConfig().GetEnabled()) {
            result["error"] = "calling RemoveChecksByFilter with disabled alerts module";
            return false;
    }
    if (!filter.size()) {
        result["error"] = "empty filter, removing all alerts not allowed";
        return false;
    }
    NJson::TJsonValue checks;
    if (!common.GetJugglerModule().GetAllChecks(checks, filter)) {
        result = checks;
        return false;
    };
    result["checks_to_remove"] = NJson::TJsonValue(NJson::JSON_ARRAY);
    ui16 oldCnt = 0;
    for (const auto& golem : checks["content"].GetMap()) {
        for (const auto& jugId : golem.second.GetMap()) {
            oldCnt++;
            NJson::TJsonValue& rm = result["checks_to_remove"].AppendValue(NJson::JSON_MAP);
            rm["juggler_id"] = jugId.first;
            rm["golem_host"] = golem.first;
        }
    }
    result["cnt_to_remove"] = oldCnt;

    bool juggRmSuccess = RemoveChecksList(common, result["checks_to_remove"], result.InsertValue("removing", NJson::JSON_MAP));
    if (!juggRmSuccess) {
        result["error"] = "some checks are not removed";
        return false;
    }
    return true;
}

bool RemoveAlertsByFilter(const NRTYDeploy::ICommonData& common, const TMap<TString, TString>& filter, NJson::TJsonValue& result) {
    if (!common.GetConfig().GetAlertsConfig().GetEnabled()) {
            result["error"] = "calling RemoveAlertsByFilter with disabled alerts module";
            return false;
    }
    if (!filter.size()) {
        result["error"] = "empty filter, removing all alerts not allowed";
        return false;
    }
    NJson::TJsonValue alerts;
    if (!common.GetGolovanModule().GetAlerts(filter, alerts)) {
        result = alerts;
        return false;
    }
    result["alerts_to_remove"] = NJson::TJsonValue(NJson::JSON_ARRAY);
    ui16 oldCnt = 0;
    for (const auto& alert : alerts["content"]["response"]["result"].GetArray()) {
        oldCnt++;
        result["alerts_to_remove"].AppendValue(alert["name"].GetString());
    }
    result["cnt_to_remove"] = oldCnt;

    bool yasmRmSuccess = RemoveAlertsList(common, result["alerts_to_remove"], result.InsertValue("removing", NJson::JSON_MAP));
    if (!yasmRmSuccess) {
        result["error"] = "some alerts are not removed";
        return false;
    }
    return true;
}

bool RemoveAllServiceChecks(const NRTYDeploy::ICommonData& common, const TString& service, const TString& ctype, NJson::TJsonValue& result) {
    const TMap<TString, TString> filter = JugglerFilter(service, ctype, "");
    NJson::TJsonValue& juggResult = result.InsertValue("checks", NJson::JSON_MAP);
    if (!RemoveChecksByFilter(common, filter, juggResult)) {
        return false;
    }
    NJson::TJsonValue& yasmResult = result.InsertValue("alerts", NJson::JSON_MAP);
    return RemoveAlertsByFilter(common, filter, yasmResult);
}
}
