#pragma once

#include <saas/deploy_manager/modules/golovan/module.h>
#include <saas/deploy_manager/modules/juggler/module.h>
#include <saas/deploy_manager/server/client/client.h>

#include <library/cpp/json/json_writer.h>
#include <util/generic/map.h>

namespace NRTYAlerts {
TMap<TString, TString> JugglerFilter(const TString& service, const TString& ctype, const TString& akey);
bool RemoveChecksList(const NRTYDeploy::ICommonData& common, const NJson::TJsonValue& checks, NJson::TJsonValue& result);
bool RemoveAlertsList(const NRTYDeploy::ICommonData& common, const NJson::TJsonValue& alerts, NJson::TJsonValue& result);
bool RemoveChecksByFilter(const NRTYDeploy::ICommonData& common, const TMap<TString, TString>& filter, NJson::TJsonValue& result);
bool RemoveAlertsByFilter(const NRTYDeploy::ICommonData& common, const TMap<TString, TString>& filter, NJson::TJsonValue& result);
bool RemoveAllServiceChecks(const NRTYDeploy::ICommonData& common, const TString& service, const TString& ctype, NJson::TJsonValue& result);
}
