#include "dead_slots_collector.h"

#include <saas/util/cluster/slot_data.h>

using namespace NRTYDeploy;

TDeadSlotsCollector::TDeadSlotsCollector(const TString& serviceName, ICommonData* commonData)
    : ServiceName(serviceName)
    , CommonData(commonData)
{
}

bool TDeadSlotsCollector::OnService(const NSearchMapParser::TSearchMapService& info) {
    return ServiceName == info.Name;
}

void TDeadSlotsCollector::OnHost(const NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& /*replica*/, const NSearchMapParser::TSearchMapService& /*service*/) {
    const NRTYCluster::TSlotData sd(host.Name, host.SearchPort);
    const IControllersChecker::TSlotInfo slotInfo = CommonData->GetControllersChecker().CheckSlot(sd);
    if (!slotInfo.IsNormalSlot) {
        DEBUG_LOG << "Slot " << host.GetSlotName() << " detected as not normal" << Endl;
        SlotsNotUsefulForRestoreSource.insert(host.GetSlotName());
    }
}

TSet<TString> TDeadSlotsCollector::GetNotUsefulSlots(const TString& serviceName, ICommonData* commonData, const NSearchMapParser::TSearchMap& ism) {
    TDeadSlotsCollector collector(serviceName, commonData);
    ism.Scan(collector);
    return collector.SlotsNotUsefulForRestoreSource;
}

