#pragma once

#include <saas/deploy_manager/storage/abstract.h>

#include <saas/library/searchmap/searchmap.h>

namespace NRTYDeploy {

    class TDeadSlotsCollector : public NSearchMapParser::ISearchMapScannerCallback {
    private:
        TString ServiceName;
        TSet<TString> SlotsNotUsefulForRestoreSource;
        ICommonData* CommonData;

    private:
        TDeadSlotsCollector(const TString& serviceName, ICommonData* commonData);

    public:
        virtual bool OnService(const NSearchMapParser::TSearchMapService& info) override;

        virtual void OnHost(const NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& replica,
            const NSearchMapParser::TSearchMapService& service) override;

        static TSet<TString> GetNotUsefulSlots(const TString& serviceName, ICommonData* commonData, const NSearchMapParser::TSearchMap& ism);
    };

} //namespace NRTYDeploy
