#pragma once

#include <saas/library/searchmap/searchmap.h>

namespace NRTYDeploy {
    class TDCAliasFilter: public NSearchMapParser::TSearchMapModifier {
    public:
        TDCAliasFilter(const TString& alias);
        virtual bool ModifyReplica(NSearchMapParser::TSearchMapReplica& replica, const NSearchMapParser::TSearchMapReplica& originalReplica, const NSearchMapParser::TSearchMapService& originalService) override;
        virtual bool ModifyHost(NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& originalReplica, const NSearchMapParser::TSearchMapService& originalService) override;
        virtual bool ModifyEndpointSet(NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& originalReplica, const NSearchMapParser::TSearchMapService& originalService) override;

    private:
        bool ModifyHostCustomWeights(NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& originalReplica, const NSearchMapParser::TSearchMapService& originalService, const TString& alias);
        bool ModifyHostAutoWeights(NSearchMapParser::TSearchMapHost& host, const NSearchMapParser::TSearchMapReplica& originalReplica, const NSearchMapParser::TSearchMapService& originalService, const TString& alias);
        TString Alias;
    };
}
