#pragma once

#include "deploy_proxy_builder.h"

namespace NRTYDeployInfo {

    class TDMDeployComponentInfo: public TProxyDeployComponentInfo {
    public:
        virtual TString GetComponentName() const override;
        virtual NSearchMapParser::TSearchMap DoSearchMapBySlot(const TString&, const NSaas::TClusterConst*, const TString&) const override;

    public:
        static TFactory::TRegistrator<TDMDeployComponentInfo> Registrator;
    };

    class TDMDeployBuilder: public TProxyDeployBuilder {
    public:
        virtual bool DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& /*context*/, TStringStream& /*errors*/, bool /*forcedOnly*/) override;

    public:
        static TFactory::TRegistrator<TDMDeployBuilder> Registrator;
    };

}
