#pragma once

#include "deploy_real_service_builder.h"

namespace NRTYDeployInfo {

    class TINTDeployComponentInfo: public TRealServiceDeployComponentInfo {
    public:
        static TFactory::TRegistrator<TINTDeployComponentInfo> Registrator;

        TString GetComponentName() const override;
        NSearchMapParser::TSearchMap DoSearchMap(const TString& /*service*/) const override;
        virtual const NSearchMapParser::TSearchMap& SearchMap() const override;
        NSearchMapParser::TSearchMap DoSearchMapBySlot(const TString& slotName, const NSaas::TClusterConst* clusterPtr, const TString& dc) const override;
        virtual TString GetSearchMapBySlotKey(const TString& slotName, const TString& dc) const override;

    };

    class TINTDeployServiceInfo: public TRealServiceDeployInfo {
    public:
        static TFactory::TRegistrator<TINTDeployServiceInfo> Registrator;
        bool DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& context, TStringStream& errors, bool forcedOnly) override;
        virtual TString GetConfigsPath() const override;
    private:
        virtual NSearchMapParser::TSearchMapService* ServiceSearchMap(NSaas::TCluster& cluster) override;
        virtual NSearchMapParser::TSearchMapService* AddService(NSaas::TCluster& cluster, const TString& name) override;
        virtual bool RemoveService(NSaas::TCluster& cluster) override;
        virtual bool DisableNotFirstReplics() const override;
    };

}
