#include "deploy_ip_builder.h"
#include "files_list_builder.h"

#include <saas/deploy_manager/scripts/common/file_content_generators/searchmap.h>
#include <saas/deploy_manager/scripts/common/file_content_generators/description.h>
#include <saas/deploy_manager/scripts/common/global_names/global_names.h>

namespace NRTYDeployInfo {

    TIPDeployComponentInfo::TFactory::TRegistrator<TIPDeployComponentInfo> TIPDeployComponentInfo::Registrator(INDEXER_PROXY_SERVICE);
    TIPDeployBuilder::TFactory::TRegistrator<TIPDeployBuilder> TIPDeployBuilder::Registrator(INDEXER_PROXY_SERVICE);

    TString TIPDeployBuilder::GetServiceConfigFilenameRegexp() const {
        return "indexerproxy-.*";
    }

    NSearchMapParser::TSearchMap TIPDeployComponentInfo::DoSearchMapBySlot(const TString& /*slotName*/, const NSaas::TClusterConst* clusterPtr, const TString& /*dc*/) const {
        return clusterPtr->IPSearchMap();
    }

    TString TIPDeployComponentInfo::GetComponentName() const {
        return INDEXER_PROXY_SERVICE;
    }

}
