#pragma once

#include "deploy_proxy_builder.h"

namespace NRTYDeployInfo {

    class TIPDeployComponentInfo: public TProxyDeployComponentInfo {
    public:
        virtual TString GetComponentName() const override;
        virtual NSearchMapParser::TSearchMap DoSearchMapBySlot(const TString& slotName, const NSaas::TClusterConst* clusterPtr, const TString& dc) const override;

    public:
        static TFactory::TRegistrator<TIPDeployComponentInfo> Registrator;
    };

    class TIPDeployBuilder: public TProxyDeployBuilder {
    public:
        static TFactory::TRegistrator<TIPDeployBuilder> Registrator;

    protected:
        virtual TString GetServiceConfigFilenameRegexp() const override;
    };

}
