#pragma once

#include "deploy_service_builder.h"

namespace NRTYDeployInfo {

    class TMetaserviceDeployComponentInfo: public TServiceDeployComponentInfo {
    public:
        static TFactory::TRegistrator<TMetaserviceDeployComponentInfo> Registrator;

        virtual NSearchMapParser::TSearchMap DoSearchMap(const TString& service) const override;
        virtual const NSearchMapParser::TSearchMap& SearchMap() const override;
        virtual TString GetComponentName() const override;
        virtual NSearchMapParser::TSearchMap DoSearchMapBySlot(const TString&, const NSaas::TClusterConst* clusterPtr, const TString&) const override;
    };

    class TMetaserviceDeployBuilder: public TServiceDeployInfo {
    public:
        static TFactory::TRegistrator<TMetaserviceDeployBuilder> Registrator;
        virtual bool DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& context, TStringStream& errors, bool /*forcedOnly*/) override;
    private:
        virtual void AddService(NSaas::TCluster& cluster) override;
        virtual void EditService(NSaas::TCluster& cluster, const NJson::TJsonValue& serviceJson) override;
        virtual void CopyService(NSaas::TCluster& cluster, const TString& newName, const bool /*clearReplicas*/) override;
        virtual bool RemoveService(NSaas::TCluster& cluster) override;
    };

}
