#include "deploy_proxy_builder.h"
#include "files_list_builder.h"

#include <saas/deploy_manager/scripts/common/file_content_generators/searchmap.h>
#include <saas/deploy_manager/scripts/common/file_content_generators/description.h>
#include <saas/deploy_manager/scripts/common/global_names/global_names.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>

namespace NRTYDeployInfo {

    NSearchMapParser::TSearchMap TProxyDeployComponentInfo::DoSearchMap(const TString& /*service*/) const {
        return SearchMap();
    }

    const NSearchMapParser::TSearchMap& TProxyDeployComponentInfo::SearchMap() const {
        if (!SearchMapCache)
            SearchMapCache = MakeHolder<NSearchMapParser::TSearchMap>(IDeployComponentInfo::SearchMap(GetComponentName(), false));
        return *SearchMapCache;
    }

    bool TProxyDeployBuilder::DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& context, TStringStream& errors, bool forcedOnly) {
        if (!IDeployServiceInfo::DoBuildFilesInfo(context, errors, forcedOnly))
            return false;
        Nodes.push_back(new NRTYDeploy::TSearchMapContentGenerator(*GetCommon(), GetCType(), ComponentInfo->GetComponentName()));

        if (TString serviceConfigFilenameRegexp = GetServiceConfigFilenameRegexp()) {
            const NSaas::TClusterConst* clusterPtr = NSaas::TClusterLocker::DefineConst(*GetCommon(), GetCType());
            if (!clusterPtr)
                ythrow yexception() << "Incorrect cluster info for " << GetCType();
            TFilesBuilderCallback rtyCb(Nodes, *ComponentInfo->GetCommon(), context, RTYSERVER_SERVICE, forcedOnly, serviceConfigFilenameRegexp);
            clusterPtr->RTYSearchMap().Scan(rtyCb);
            TFilesBuilderCallback metaCb(Nodes, *ComponentInfo->GetCommon(), context, META_SERVICE_SERVICE, forcedOnly, serviceConfigFilenameRegexp);
            clusterPtr->MetaServiceSearchMap().Scan(metaCb);
        }
        return true;
    }

    TDuration TProxyDeployBuilder::GetStopTimeout() const {
        return TDuration::Seconds(100);
    }

    TString TProxyDeployBuilder::GetConfigsPath() const {
        return "/configs/" + ComponentInfo->GetComponentName();
    }

    TString TProxyDeployBuilder::GetServiceConfigFilenameRegexp() const {
        return TString();
    }

}
