#pragma once

#include "deploy_builder.h"

namespace NRTYDeployInfo {

    class TProxyDeployComponentInfo: public IDeployComponentInfo {
    public:
        virtual NSearchMapParser::TSearchMap DoSearchMap(const TString& service) const override;
        virtual const NSearchMapParser::TSearchMap& SearchMap() const override;

    private:
        mutable THolder<NSearchMapParser::TSearchMap> SearchMapCache;
    };

    class TProxyDeployBuilder: public IDeployServiceInfo {
    public:
        virtual TString GetConfigsPath() const override;
        virtual TDuration GetStopTimeout() const override;
        virtual bool DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& context, TStringStream& errors, bool forcedOnly) override;

    protected:
        virtual TString GetServiceConfigFilenameRegexp() const;
    };

}
