#pragma once

#include "deploy_service_builder.h"

namespace NRTYDeployInfo {

    class TRealServiceDeployComponentInfo : public TServiceDeployComponentInfo {
    public:
    };

    class TRealServiceDeployInfo : public TServiceDeployInfo {
    public:
        virtual void AddNewSlots(const NSearchMapParser::TSlotsPool& slotsPool, NSaas::TCluster& cluster) override;
        virtual bool DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& context, TStringStream& errors, bool /*forcedOnly*/) override;

    private:
        virtual void DoCorrectTopologyAction(const TCgiParameters& cgi, const NSearchMapParser::TSlotsPool* slotsPool, NSaas::TCluster& cluster, const TString& action) override;
        virtual void AddService(NSaas::TCluster& cluster) override;
        virtual void EditService(NSaas::TCluster& cluster, const NJson::TJsonValue& serviceJson) override;
        virtual void CopyService(NSaas::TCluster& cluster, const TString& newName, const bool clearReplicas) override;
        virtual NSearchMapParser::TSearchMapService* ServiceSearchMap(NSaas::TCluster& cluster) = 0;
        virtual NSearchMapParser::TSearchMapService* AddService(NSaas::TCluster& cluster, const TString& name) = 0;
        virtual bool DisableNotFirstReplics() const = 0;
    };
}
