#include "deploy_rty_builder.h"

#include <saas/deploy_manager/scripts/common/file_content_generators/description.h>
#include <saas/protos/cluster.pb.h>
#include <saas/library/searchmap/parsers/json/json.h>
#include <library/cpp/json/json_reader.h>

namespace NRTYDeployInfo {

    TRTYServiceDeployInfo::TFactory::TRegistrator<TRTYServiceDeployInfo> TRTYServiceDeployInfo::Registrator(RTYSERVER_SERVICE);
    TRTYDeployComponentInfo::TFactory::TRegistrator<TRTYDeployComponentInfo> TRTYDeployComponentInfo::Registrator(RTYSERVER_SERVICE);

    NSearchMapParser::TSearchMap TRTYDeployComponentInfo::DoSearchMap(const TString& service) const {
        const NSaas::TClusterConst* clusterPtr = NSaas::TClusterLocker::DefineConst(*GetCommon(), GetCType());
        if (!clusterPtr) {
            ythrow yexception() << "Incorrect cluster info for " << GetCType();
        }

        NSearchMapParser::TSearchMap result;
        const NSearchMapParser::TSearchMapService* servicePtr = clusterPtr->ServiceSearchMap(service);
        if (servicePtr) {
            result.AddService(service) = *servicePtr;
        }
        return result;
    }

    const NSearchMapParser::TSearchMap& TRTYDeployComponentInfo::SearchMap() const {
        const NSaas::TClusterConst* clusterPtr = NSaas::TClusterLocker::DefineConst(*GetCommon(), GetCType());
        if (!clusterPtr) {
            ythrow yexception() << "Incorrect cluster info for " << GetCType();
        }
        return clusterPtr->RTYSearchMap();
    }

    TDuration TRTYServiceDeployInfo::GetStopTimeout() const {
        return TDuration::Seconds(120);
    }

    NSearchMapParser::TSearchMapService* TRTYServiceDeployInfo::ServiceSearchMap(NSaas::TCluster& cluster) {
        return cluster.ServiceSearchMap(Service);
    }

    NSearchMapParser::TSearchMapService* TRTYServiceDeployInfo::AddService(NSaas::TCluster& cluster, const TString& name) {
        return cluster.AddRTYService(name);
    }

    bool TRTYServiceDeployInfo::RemoveService(NSaas::TCluster& cluster) {
        return cluster.RemoveRtyService(Service);
    }

    bool TRTYServiceDeployInfo::DisableNotFirstReplics() const {
        return true;
    }

}
