#pragma once

#include "deploy_real_service_builder.h"
#include <saas/deploy_manager/scripts/common/global_names/global_names.h>
#include <saas/deploy_manager/scripts/common/file_content_generators/sla_description.h>

namespace NRTYDeployInfo {

    class TRTYDeployComponentInfo: public TRealServiceDeployComponentInfo {
    public:
        static TFactory::TRegistrator<TRTYDeployComponentInfo> Registrator;

        virtual TString GetComponentName() const override {
            return RTYSERVER_SERVICE;
        }

        virtual NSearchMapParser::TSearchMap DoSearchMap(const TString& /*service*/) const override;
        virtual const NSearchMapParser::TSearchMap& SearchMap() const override;
    };

    class TRTYServiceDeployInfo: public TRealServiceDeployInfo {
    public:
        static TFactory::TRegistrator<TRTYServiceDeployInfo> Registrator;

        virtual TDuration GetStopTimeout() const override;
    private:
        virtual NSearchMapParser::TSearchMapService* ServiceSearchMap(NSaas::TCluster& cluster) override;
        virtual NSearchMapParser::TSearchMapService* AddService(NSaas::TCluster& cluster, const TString& name) override;
        virtual bool RemoveService(NSaas::TCluster& cluster) override;
        virtual bool DisableNotFirstReplics() const override;

        bool DoBuildFilesInfo(const NRTYDeploy::TFileContentGenerator::TContext& context, TStringStream& errors, bool forcedOnly) override {
            if (!TRealServiceDeployInfo::DoBuildFilesInfo(context, errors, forcedOnly)) {
                return false;
            }
            Nodes.push_back(
                new NRTYDeploy::TSlaDescriptionFileContentGenerator(
                    GetConfigsPath() + "/" + NRTYDeploy::TSlaDescriptionFileContentGenerator::GetRename(Service),
                    *ComponentInfo->GetCommon(),
                    Service
                )
            );
            return true;
        }
    };

}
