#include "deploy_service_builder.h"

#include <saas/deploy_manager/scripts/common/alerts/remove.h>

#include <util/string/type.h>

using namespace NRTYAlerts;

namespace NRTYDeployInfo {
    void TServiceDeployInfo::CorrectTopology(const TCgiParameters& cgi, const NSearchMapParser::TSlotsPool* slotsPool, NSaas::TCluster& cluster) {
        TString actions = cgi.Get("action");
        TVector<TString> vActions = SplitString(actions, ",");
        for (auto&& i : vActions) {
            CorrectTopologyAction(cgi, slotsPool, cluster, i);
        }
    }

    void TServiceDeployInfo::CorrectTopologyAction(const TCgiParameters& cgi, const NSearchMapParser::TSlotsPool* slotsPool, NSaas::TCluster& cluster, const TString& action) {
        if (action == "add_service") {
            AddService(cluster);
            return;
        }

        if (action == "edit_service") {
            NJson::TJsonValue serviceInfo;
            TStringInput si(cgi.Get("service_info"));
            if (!NJson::ReadJsonTree(&si, &serviceInfo))
                ythrow yexception() << "Incorrect service info";
            EditService(cluster, serviceInfo);
            return;
        }

        if (action == "rename_service") {
            CopyServiceWithConfigs(cluster, cgi);
            RemoveServiceAlerts();
            RemoveService(cluster);
            ComponentInfo->GetCommon()->GetStorage().RemoveNode(GetConfigsPath());
            return;
        }

        if (action == "copy_service") {
            CopyServiceWithConfigs(cluster, cgi, true);
            return;
        }

        if (action == "remove_service") {
            RemoveServiceAlerts();
            if (!RemoveService(cluster))
                ythrow yexception() << "there is no service " << ComponentInfo->GetComponentName() << "/" << Service;
            return;
        }

        DoCorrectTopologyAction(cgi, slotsPool, cluster, action);
    }

    TDuration TServiceDeployInfo::GetStopTimeout() const {
        return TDuration::Seconds(100);
    }

    void TServiceDeployInfo::CopyServiceWithConfigs(NSaas::TCluster& cluster, const TCgiParameters& cgi, const bool clearReplicas) {
        const TString& newName = cgi.Get("new_service_name");
        if (!newName)
            ythrow yexception() << "there is no new_service_name";
        if (IsTrue(cgi.Get("add_to_search_map"))) {
            CopyService(cluster, newName, clearReplicas);
        }
        ComponentInfo->GetCommon()->GetStorage().CopyPath(GetConfigsPath(), newName, "");
    }

    void TServiceDeployInfo::RemoveServiceAlerts() {
        if (GetCommon()->GetConfig().GetAlertsConfig().GetEnabled()) {
            NJson::TJsonValue alertsRes;
            if (!RemoveAllServiceChecks(*GetCommon(), Service, GetCType(), alertsRes)) {
                ythrow yexception() << "failed to remove service alerts, service: " << Service << ", error: " << alertsRes.GetStringRobust();
            }
        }
    }

    void TServiceDeployInfo::DoCorrectTopologyAction(const TCgiParameters& /*cgi*/, const NSearchMapParser::TSlotsPool* /*slotsPool*/, NSaas::TCluster& /*cluster*/, const TString& action) {
        ythrow yexception() << "Incorrect action " << action;
    }
}
