#pragma once

#include "deploy_builder.h"

namespace NRTYDeployInfo {

    class TServiceDeployComponentInfo: public IDeployComponentInfo {
    public:
    };

    class TServiceDeployInfo: public IDeployServiceInfo {
    public:
        virtual TDuration GetStopTimeout() const override;
        virtual void CorrectTopology(const TCgiParameters& cgi, const NSearchMapParser::TSlotsPool* slotsPool, NSaas::TCluster& cluster) override;

    private:
        void CorrectTopologyAction(const TCgiParameters& cgi, const NSearchMapParser::TSlotsPool* slotsPool, NSaas::TCluster& cluster, const TString& action);
        virtual void DoCorrectTopologyAction(const TCgiParameters& cgi, const NSearchMapParser::TSlotsPool* slotsPool, NSaas::TCluster& cluster, const TString& action);
        virtual void AddService(NSaas::TCluster& cluster) = 0;
        virtual void EditService(NSaas::TCluster& cluster, const NJson::TJsonValue& serviceJson) = 0;
        virtual void CopyService(NSaas::TCluster& cluster, const TString& newName, bool clearReplicas = false) = 0;
        void CopyServiceWithConfigs(NSaas::TCluster& cluster, const TCgiParameters& cgi, const bool clearReplicas = false);
        virtual bool RemoveService(NSaas::TCluster& cluster) = 0;
        void RemoveServiceAlerts();
    };

}
