#include "deploy_sp_builder.h"
#include "dc_alias_filter.h"

#include <saas/deploy_manager/scripts/common/global_names/global_names.h>

namespace NRTYDeployInfo {

    TSPDeployServiceInfo::TFactory::TRegistrator<TSPDeployServiceInfo> TSPDeployServiceInfo::Registrator(SEARCH_PROXY_SERVICE);
    TSPDeployComponentInfo::TFactory::TRegistrator<TSPDeployComponentInfo> TSPDeployComponentInfo::Registrator(SEARCH_PROXY_SERVICE);

    TString TSPDeployServiceInfo::GetServiceConfigFilenameRegexp() const {
        return "searchproxy-.*|query-language-.*|sla_description-.*";
    }

    TString TSPDeployComponentInfo::GetSearchMapBySlotKey(const TString& slotName, const TString& dc) const {
        NRTYCluster::TSlotData slotData;
        if (!NRTYCluster::TSlotData::Parse(slotName, slotData)) {
            ythrow yexception() << "incorrect slot name: " << slotName;
        }
        TString alias = slotData.GetDCAlias(true, dc);
        return alias;
    }

    NSearchMapParser::TSearchMap TSPDeployComponentInfo::DoSearchMapBySlot(const TString& slotName, const NSaas::TClusterConst* clusterPtr, const TString& dc) const {
        NRTYCluster::TSlotData slotData;
        if (!NRTYCluster::TSlotData::Parse(slotName, slotData)) {
            ythrow yexception() << "incorrect slot name: " << slotName;
        }

        TString alias = slotData.GetDCAlias(true, dc);
        return NRTYDeploy::TDCAliasFilter(alias).Process(clusterPtr->SPSearchMap());
    }

    TString TSPDeployComponentInfo::GetComponentName() const {
        return SEARCH_PROXY_SERVICE;
    }

}
