#pragma once

#include "deploy_proxy_builder.h"

namespace NRTYDeployInfo {

    class TSPDeployComponentInfo: public TProxyDeployComponentInfo{
    public:
        virtual TString GetComponentName() const override;
        virtual NSearchMapParser::TSearchMap DoSearchMapBySlot(const TString& slotName, const NSaas::TClusterConst* clusterPtr, const TString& dc) const override;
        virtual TString GetSearchMapBySlotKey(const TString& slotName, const TString& dc) const override;

    public:
        static TFactory::TRegistrator<TSPDeployComponentInfo> Registrator;
    };

    class TSPDeployServiceInfo: public TProxyDeployBuilder {
    public:
        static TFactory::TRegistrator<TSPDeployServiceInfo> Registrator;

    protected:
        virtual TString GetServiceConfigFilenameRegexp() const override;
    };

}
