#pragma once
#include <saas/library/searchmap/searchmap.h>
#include <saas/deploy_manager/storage/abstract.h>
#include <saas/deploy_manager/scripts/common/file_content_generators/common.h>
#include <library/cpp/regex/pcre/regexp.h>
#include "deploy_builder.h"

namespace NRTYDeployInfo {
    class TFilesBuilderCallback: public NSearchMapParser::ISearchMapScannerCallback {
    public:
        TFilesBuilderCallback(NRTYDeploy::TNodesStructure& nodes, const NRTYDeploy::ICommonData& common, const NRTYDeploy::TFileContentGenerator::TContext& context, const TString& serviceType, bool forcedOnly, const TString& regFilter);

        virtual bool OnService(const NSearchMapParser::TSearchMapService& info);

        virtual void OnHost(const NSearchMapParser::TSearchMapHost& /*host*/, const NSearchMapParser::TSearchMapReplica& /*replica*/, const NSearchMapParser::TSearchMapService& /*service*/) {
        };
    private:
        NRTYDeploy::TNodesStructure& Nodes;
        const NRTYDeploy::ICommonData& Common;
        const NRTYDeploy::TFileContentGenerator::TContext& Context;
        TString ServiceType;
        IDeployComponentInfo::TPtr Component;
        bool ForcedOnly;
        TRegExMatch RegExFilter;
    };
}
