#pragma once

#include "common.h"
#include <library/cpp/cache/thread_safe_cache.h>

namespace NRTYDeploy {

    class TCachedFileContentGenerator : public TFileContentGenerator {
    public:
        virtual bool GetContent(TString& result, const ICommonData& common, const TContext& context) const override;
        virtual bool GetContentHash(TString& result, const ICommonData& common, const TContext& context) const override;
        static void ClearCaches();

    protected:
        virtual bool DoGetContent(TString& result, const ICommonData& common, const TContext& context) const = 0;
        virtual TString GetCacheKey(const TContext& context) const = 0;

    private:
        struct TCacheRecord {
            TString Content;
            TString Hash;
        };

        typedef TThreadSafeCache<TString, TCacheRecord, const ICommonData&, const TCachedFileContentGenerator&, const TContext&> TCache;

        class TCallbacks : public TCache::ICallbacks {
        public:
            virtual TKey GetKey(const ICommonData& /*common*/, const TCachedFileContentGenerator& generator, const TContext& context) const override;
            virtual TCacheRecord* CreateObject(const ICommonData& common, const TCachedFileContentGenerator& generator, const TContext& context) const override;
        };
    };

}
