#include "config_type.h"

#define CONFIG_TYPE_FILE_CONTENT_GENTRATOR_TYPE "config_type_container"

namespace NRTYDeploy {

    TString TConfigTypeFileContentGenerator::GetType() const {
        return CONFIG_TYPE_FILE_CONTENT_GENTRATOR_TYPE;
    }

    bool TConfigTypeFileContentGenerator::GetContent(TString& result, const ICommonData& common, const TContext& context) const {
        TPtr gen;
        if(!FindSlotInfo(context, gen))
            return false;
        return gen->GetContent(result, common, context);
    }

    bool TConfigTypeFileContentGenerator::GetContentHash(TString& result, const ICommonData& common, const TContext& context) const {
        TPtr gen;
        if (!FindSlotInfo(context, gen))
            return false;
        return gen->GetContentHash(result, common, context);
    }

    TString TConfigTypeFileContentGenerator::GetRename(const TContext& context) const {
        TPtr gen;
        if (!FindSlotInfo(context, gen))
            return TString();
        return gen->GetRename(context);
    }

    void TConfigTypeFileContentGenerator::Serialize(NJson::TJsonValue& json) const {
        TFileContentGenerator::Serialize(json);
        if (Generators.empty())
            return;
        NJson::TJsonValue& byConfType = json.InsertValue("by_config_type", NJson::JSON_MAP);
        for (TGenByConfType::const_iterator i = Generators.begin(); i != Generators.end(); ++i)
            i->second->Serialize(byConfType.InsertValue(i->first, NJson::JSON_MAP));
    }

    void TConfigTypeFileContentGenerator::AddGenerator(TPtr gen) {
        Generators["default"] = gen;
    }

    void TConfigTypeFileContentGenerator::AddGenerator(const ICommonData& common, const TFsPath& path, const NSaas::TSlotInfo& slotInfo) {
        TPtr gen = Create(path, common, slotInfo);
        AddGenerator(gen);
    }

    void TConfigTypeFileContentGenerator::DoDeserialize(const NJson::TJsonValue& json) {
        TFileContentGenerator::DoDeserialize(json);
        const NJson::TJsonValue::TMapType* map(nullptr);
        Generators.clear();
        if (json.Has("by_config_type") && json["by_config_type"].GetMapPointer(&map))
            for (NJson::TJsonValue::TMapType::const_iterator i = map->begin(); i != map->end(); ++i)
                Generators[i->first] = Deserialize(i->second);
    }

    bool TConfigTypeFileContentGenerator::FindSlotInfo(const TContext& context, TPtr& result) const {
        TString configType = context.SlotInfo.ConfigType;
        TGenByConfType::const_iterator i = Generators.find(configType);
        if (i == Generators.end())
            return false;
        result = i->second;
        return true;
    }

    void TConfigTypeFileContentGenerator::SetLastVersion() {
        for (TGenByConfType::iterator i = Generators.begin(); i != Generators.end(); ++i)
            i->second->SetLastVersion();
    }

    TConfigTypeFileContentGenerator::TFactory::TRegistrator<TConfigTypeFileContentGenerator> TConfigTypeFileContentGenerator::Registrar(CONFIG_TYPE_FILE_CONTENT_GENTRATOR_TYPE);

}
