#pragma once

#include "common.h"
#include <util/folder/path.h>

namespace NRTYDeploy {

#define CONFIG_TYPE_FILE_CONTENT_GENTRATOR_TYPE "config_type_container"

    class TConfigTypeFileContentGenerator : public TFileContentGenerator {
    public:
        virtual TString GetType() const override;
        virtual bool GetContent(TString& result, const ICommonData& common, const TContext& context) const override;
        virtual bool GetContentHash(TString& result, const ICommonData& common, const TContext& context) const override;
        virtual TString GetRename(const TContext& context) const override;
        virtual void Serialize(NJson::TJsonValue& json) const override;
        virtual void SetLastVersion() override;
        void AddGenerator(const ICommonData& common, const TFsPath& path, const NSaas::TSlotInfo& slotInfo);
        void AddGenerator(TPtr gen);
        static TString GetConfigTypeByFileName(const TString& name);

        static TFactory::TRegistrator<TConfigTypeFileContentGenerator> Registrar;

    protected:
        virtual void DoDeserialize(const NJson::TJsonValue& json) override;

    private:
        typedef THashMap<TString, TPtr> TGenByConfType;
        bool FindSlotInfo(const TContext& context, TPtr& result) const;
        TGenByConfType Generators;
        TString ServiceType;
    };

}
