#include "description.h"

#define DESCRIPTION_FILE_CONTENT_GENERATOR_TYPE "description"
#define DESCRIPTION_FILE_NAME "description"

namespace NRTYDeploy {

    TString TDescriptionFileContentGenerator::GetType() const {
        return DESCRIPTION_FILE_CONTENT_GENERATOR_TYPE;
    }

    TString TDescriptionFileContentGenerator::GetRename(const TContext& /*context*/) const {
        return DESCRIPTION_FILE_NAME;
    }

    bool TDescriptionFileContentGenerator::GetContent(TString& result, const ICommonData& /*common*/, const TContext& context) const {
        result = GetContentImpl(context);
        return true;
    }

    TString TDescriptionFileContentGenerator::GetContentImpl(const TContext& context) const {
        return context.SlotInfo.ToString();
    }

    TDescriptionFileContentGenerator::TFactory::TRegistrator<TDescriptionFileContentGenerator> TDescriptionFileContentGenerator::Registrar(DESCRIPTION_FILE_CONTENT_GENERATOR_TYPE);

}
