#pragma once

#include "common.h"
#include <util/folder/path.h>

namespace NRTYDeploy {
    class TEnvironmentFileContentGenerator : public TFileContentGenerator {
    public:
        TEnvironmentFileContentGenerator();
        TEnvironmentFileContentGenerator(const TFsPath& path, const ICommonData& data, i64 version = -1);
        virtual TString GetType() const override;
        virtual TString GetRename(const TContext& context) const override;
        virtual void SetLastVersion() override;
        virtual void Serialize(NJson::TJsonValue& json) const override;
        virtual bool GetContent(TString& result, const ICommonData& common, const TContext& context) const override;

        static TFactory::TRegistrator<TEnvironmentFileContentGenerator> Registrar;

    protected:
        virtual void DoDeserialize(const NJson::TJsonValue& json) override;

    private:
        TPtr Slave;
    };
}
