#pragma once

#include "cached.h"
#include <util/folder/path.h>

namespace NRTYDeploy {

    class TPlainFileContentGenerator : public TCachedFileContentGenerator {
    public:
        TPlainFileContentGenerator();
        TPlainFileContentGenerator(const TFsPath& path, const ICommonData& data, i64 version = -1);
        virtual TString GetType() const override;
        virtual void Serialize(NJson::TJsonValue& json) const override;
        virtual TString GetRename(const TContext& context) const override;
        virtual void SetLastVersion() override;

        static TFactory::TRegistrator<TPlainFileContentGenerator> Registrar;

    protected:
        virtual void DoDeserialize(const NJson::TJsonValue& json) override;
        virtual bool DoGetContent(TString& result, const ICommonData& common, const TContext& context) const override;
        virtual TString GetCacheKey(const TContext& context) const override;

    private:
        TFsPath Path;
        i64 Version;
    };

}
