#include "proxy.h"
#include <saas/deploy_manager/scripts/common/global_names/global_names.h>
#include <saas/deploy_manager/scripts/common/scripts_helper.h>

#define PROXY_FILE_CONTENT_GENERATOR_TYPE "proxy"

namespace NRTYDeploy {

    TProxyFileContentGenerator::TProxyFileContentGenerator()
    {}

    TProxyFileContentGenerator::TProxyFileContentGenerator(const TFsPath& path, const ICommonData& data, const TString& service, i64 version)
        : TPlainFileContentGenerator(path, data, version)
        , Service(service)
    {}

    TString TProxyFileContentGenerator::GetType() const {
        return PROXY_FILE_CONTENT_GENERATOR_TYPE;
    }

    void TProxyFileContentGenerator::Serialize(NJson::TJsonValue& json) const {
        TPlainFileContentGenerator::Serialize(json);
        json.InsertValue("service", Service);
    }

    TString TProxyFileContentGenerator::GetRename(const TContext& context) const {
        TContext correctContext = context;
        correctContext.SlotInfo.Service = Service;
        TString name = TPlainFileContentGenerator::GetRename(correctContext);

        if (context.SlotInfo.ServiceType == INDEXER_PROXY_SERVICE && name.StartsWith("indexerproxy-")
            || context.SlotInfo.ServiceType == SEARCH_PROXY_SERVICE  && (name.StartsWith("searchproxy-") || name.StartsWith("query-language-"))
            || context.SlotInfo.ServiceType == RTYSERVER_SERVICE && name.StartsWith("query-language-")
        ) {
            return name;
        }

        return "";
    }

    void TProxyFileContentGenerator::DoDeserialize(const NJson::TJsonValue& json) {
        TPlainFileContentGenerator::DoDeserialize(json);
        Service = json["service"].GetStringRobust();
    }

    bool TProxyFileContentGenerator::DoGetContent(TString& result, const ICommonData& common, const TContext& context) const {
        TContext correctContext = context;
        correctContext.SlotInfo.Service = Service;

        return TPlainFileContentGenerator::DoGetContent(result, common, correctContext);
    }

    TProxyFileContentGenerator::TFactory::TRegistrator<TProxyFileContentGenerator> TProxyFileContentGenerator::Registrar(PROXY_FILE_CONTENT_GENERATOR_TYPE);
}
