#pragma once

#include "plain.h"
#include <util/folder/path.h>

namespace NRTYDeploy {

    class TProxyFileContentGenerator : public TPlainFileContentGenerator {
    public:
        TProxyFileContentGenerator();
        TProxyFileContentGenerator(const TFsPath& path, const ICommonData& data, const TString& service, i64 version = -1);
        virtual TString GetType() const override;
        virtual void Serialize(NJson::TJsonValue& json) const override;
        virtual TString GetRename(const TContext& context) const override;

        static TFactory::TRegistrator<TProxyFileContentGenerator> Registrar;

    protected:
        virtual void DoDeserialize(const NJson::TJsonValue& json) override;
        virtual bool DoGetContent(TString& result, const ICommonData& common, const TContext& context) const override;
    private:
        TString Service;
    };

}
